/*
 * Decompiled with CFR 0.152.
 */
package dev.obscuria.lootjournal.client.render;

import com.mojang.blaze3d.systems.RenderSystem;
import dev.obscuria.lootjournal.LootJournal;
import dev.obscuria.lootjournal.client.pickup.IPickupEntry;
import net.minecraft.class_124;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_332;
import net.minecraft.class_5250;
import net.minecraft.class_5348;

public enum PickupDrawStyle {
    CLASSIC(PickupDrawStyle::renderClassic),
    FLAT(PickupDrawStyle::renderFlat),
    TEXT(PickupDrawStyle::renderText);

    private static final class_2960 DECORATIONS;
    private final Renderer renderer;

    private PickupDrawStyle(Renderer renderer) {
        this.renderer = renderer;
    }

    public void render(IPickupEntry pickup, class_332 graphics, int y, double progress, long time) {
        class_327 font = class_310.method_1551().field_1772;
        class_5250 name = pickup.getDisplayName();
        class_5250 total = pickup.shouldDisplayTotalAmount() ? class_2561.method_43470((String)String.valueOf(pickup.getTotalAmount())) : class_2561.method_43473();
        int totalWidth = pickup.shouldDisplayTotalAmount() ? font.method_27525((class_5348)total) + 5 : 0;
        graphics.method_51448().method_22903();
        graphics.method_51448().method_22904(PickupDrawStyle.getX(progress), (double)y, 100.0);
        RenderSystem.enableBlend();
        this.renderer.render(pickup, graphics, font, name, font.method_27525((class_5348)name), total, totalWidth, time);
        RenderSystem.disableBlend();
        graphics.method_51448().method_22909();
    }

    private static void renderClassic(IPickupEntry pickup, class_332 graphics, class_327 font, class_5250 name, int nameWidth, class_5250 total, int totalWidth, long time) {
        if (PickupDrawStyle.isReversed()) {
            graphics.method_25290(DECORATIONS, -36 - nameWidth - totalWidth, 0, 0.0f, 0.0f, 256, 12, 256, 256);
            graphics.method_25290(DECORATIONS, -26 - totalWidth, 1, 0.0f, 12.0f, 256, 10, 256, 256);
            graphics.method_27535(font, (class_2561)name, -29 - nameWidth - totalWidth, 2, 0xFFFFFF);
            graphics.method_27535(font, (class_2561)total.method_27692(class_124.field_1080), -totalWidth, 2, 0xFFFFFF);
            PickupDrawStyle.renderIcon(pickup, graphics, -11 - totalWidth, 6.0, time);
        } else {
            graphics.method_25290(DECORATIONS, -218 + nameWidth + totalWidth, 0, 0.0f, 0.0f, 256, 12, 256, 256);
            graphics.method_25290(DECORATIONS, -230 + totalWidth, 1, 0.0f, 12.0f, 256, 10, 256, 256);
            graphics.method_27535(font, (class_2561)name, 30 + totalWidth, 2, 0xFFFFFF);
            graphics.method_27535(font, (class_2561)total.method_27692(class_124.field_1080), 5, 2, 0xFFFFFF);
            PickupDrawStyle.renderIcon(pickup, graphics, 11 + totalWidth, 6.0, time);
        }
    }

    private static void renderFlat(IPickupEntry pickup, class_332 graphics, class_327 font, class_5250 name, int nameWidth, class_5250 total, int totalWidth, long time) {
        if (PickupDrawStyle.isReversed()) {
            graphics.method_25294(-3, 0, -25 - nameWidth - totalWidth, 12, Integer.MIN_VALUE);
            graphics.method_27535(font, (class_2561)name, -23 - nameWidth - totalWidth, 2, 0xFFFFFF);
            graphics.method_27535(font, (class_2561)total.method_27692(class_124.field_1080), -totalWidth, 2, 0xFFFFFF);
            PickupDrawStyle.renderIcon(pickup, graphics, -11 - totalWidth, 6.0, time);
        } else {
            graphics.method_25294(3, 0, 25 + nameWidth + totalWidth, 12, Integer.MIN_VALUE);
            graphics.method_27535(font, (class_2561)name, 23 + totalWidth, 2, 0xFFFFFF);
            graphics.method_27535(font, (class_2561)total.method_27692(class_124.field_1080), 5, 2, 0xFFFFFF);
            PickupDrawStyle.renderIcon(pickup, graphics, 11 + totalWidth, 6.0, time);
        }
    }

    private static void renderText(IPickupEntry pickup, class_332 graphics, class_327 font, class_5250 name, int nameWidth, class_5250 total, int totalWidth, long time) {
        if (PickupDrawStyle.isReversed()) {
            graphics.method_27535(font, (class_2561)name, -23 - nameWidth - totalWidth, 2, 0xFFFFFF);
            graphics.method_27535(font, (class_2561)total.method_27692(class_124.field_1080), -totalWidth, 2, 0xFFFFFF);
            PickupDrawStyle.renderIcon(pickup, graphics, -11 - totalWidth, 6.0, time);
        } else {
            graphics.method_27535(font, (class_2561)name, 23 + totalWidth, 2, 0xFFFFFF);
            graphics.method_27535(font, (class_2561)total.method_27692(class_124.field_1080), 5, 2, 0xFFFFFF);
            PickupDrawStyle.renderIcon(pickup, graphics, 11 + totalWidth, 6.0, time);
        }
    }

    private static void renderIcon(IPickupEntry pickup, class_332 graphics, double x, double y, long time) {
        graphics.method_51448().method_22903();
        graphics.method_51448().method_22904(x, y, 0.0);
        pickup.renderIcon(graphics, time);
        graphics.method_51448().method_22909();
    }

    private static double getX(double progress) {
        double offset = -220.0 + 220.0 * (1.0 - Math.pow(progress - 1.0, 2.0));
        return PickupDrawStyle.isReversed() ? -offset : offset;
    }

    private static boolean isReversed() {
        return LootJournal.CONFIG.anchor.isReversed();
    }

    static {
        DECORATIONS = LootJournal.key("textures/gui/decorations.png");
    }

    @FunctionalInterface
    private static interface Renderer {
        public void render(IPickupEntry var1, class_332 var2, class_327 var3, class_5250 var4, int var5, class_5250 var6, int var7, long var8);
    }
}

